@echo off

setlocal

cd /d %~dp0

REM ----- Confirm 1st parameter (Remote PC)
if %1. == . (
	set RemoteName=
) else (
	set RemoteName=%1\
)

REM ----- Check if referrable to the registory
reg query %RemoteName%HKLM\SOFTWARE\Microsoft 1>nul
if errorlevel 1 (
	echo %0F Error: Can't refer the registory
	endlocal
	exit /b
)

REM ----- Registory Entry
set RegKey11=%RemoteName%HKLM\SOFTWARE\Microsoft\NET Framework Setup\NDP

REM ----- Check each version
call :Detect4     ".NET Framework 4"   "%RegKey11%\v4"
call :Detect11_35 ".NET Framework 3.5" "%RegKey11%\v3.5"

REM ----- End of Process

rem Installation Failed
endlocal
exit /b

REM --------------------------------------
:Detect11_35
reg query "%~2" /v "Install" 2>nul | find /I "Install" 2>nul | find /I "0x1" 1>nul 2>nul
if errorlevel 1 goto NoExist11
reg query "%~2" /v "SP" 2>nul | find /I "SP" 1>nul 2>nul
if errorlevel 1 goto NoExist11
	echo .NET Framework 3.5 is installed
	cd Data\DotNet35
	goto StartCopy
:NoExist11
exit /b


REM --------------------------------------
:Detect4
reg query "%~2\Full" /v "Install" 2>nul | find /I "Install" 2>nul | find /I "0x1" 1>nul 2>nul
if not errorlevel 1 (
	echo .NET Framework 4 is installed
	cd Data\DotNet4x
	goto StartCopy
	endlocal
	exit
) else (
	REM ----- Check if 4.0 Client Profile is installed
	reg query "%~2\Client" /v "Install" 2>nul | find /I "Install" 2>nul | find /I "0x1" 1>nul 2>nul
	if not errorlevel 1 (
		echo .NET Framework 4 Client Profile is installed
		cd Data\DotNet4x
		goto StartCopy
	)
)

exit /b


:StartCopy
for /F "usebackq delims=" %%a in (`dir *.exe /b`) do set AppName=%%a
%AppName% initialcopy
endlocal
exit
